//
//  AudioModel.h
//  LSAudioControls
//
//  Created by Todd Stanley on 7/28/08.
//  Copyright 2008-2010 Livescribe. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <QTKit/QTKit.h>
#import "PencastAudioModel.h"



@interface AudioModel : PencastAudioModel
{
	QTMovie			*mMovie;
}

@property(retain) SessionInfoFile	*sessionInfo;
@property(retain) NSArray			*audioStartTimes;
@property(retain) NSMutableArray	*bookmarks;
@property(retain) NSString			*sessionGUID;

- (id)initWithSoundFiles:(NSArray*)aacFiles sessionInfoData:(NSData*)sessionInfoData bookmarks:(NSArray*)bookmarkFiles;
- (id)initWithSoundFiles:(NSArray*)aacFiles sessionInfo:(NSString*)sessionInfoPath bookmarks:(NSArray*)bookmarksPath;
-(void)loadSessionInfoData:(NSData *)sessionInfoData;

- (void)appendFileToMovie:(NSString *)fileName;
- (BOOL)writeToFile:(NSString*)path error:(NSError**)error;
- (BOOL)writeToFile:(NSString*)path error:(NSError**)error type:(long)type;
- (BOOL)writeFlashAudioToFile:(NSString*)path error:(NSError**)error;

- (BOOL)isPlaying;

- (void)play;
- (void)stop;

- (double)durationSeconds;

- (double)currentTimeSeconds;
- (BOOL)setCurrentTimeSeconds:(double)seconds;
- (BOOL)setCurrentTime:(QTTime)time;

- (long long)_currentTime;
- (void)_setCurrentTime:(long long)startTime;

- (float)rate;
- (void)setRate:(float)rate;

- (float)volume;
- (void)setVolume:(float)volume;

- (void)jumpForward;
- (void)jumpBackward;

- (void)jumpToNextBookmark;
- (void)jumpToPrevBookmark;

- (NSMutableArray*)bookmarks;

+(int)segmentNumberFromFilePath:(NSString*)path;

// Should be removed

- (void) setRenderQuality:(UInt32)quality;
- (QTMovie*)movie;

@end
